 ; Ŀ
 ;   Squab - Adjust attribute widths.                                      
 ;   Copyright 1995, 1997, 1999, 2002 - 2010 by Rocket Software Ltd.       
 ;   No, it's not named after those little Swedish cars.                   
 ; 

 (defun c:test ()
;  (print (wcasoc "A*" '((2 3) ("saa" 22) ("a2" 23)) ()))
  (print (wcmatch "PEL_DWG#" "PEL_DWG`#"))
 (princ))
 ; Ŀ
 ;   Subroutine Blister - make the list of blocks, attributes, and widths. 
 ;   The format is:                                                        
 ;   '(Blockname (Attribute_tag1 Maximum_width Ideal_width_scale) ...)     
 ;   Notes: 1. Don't forget the leading quote.                             
 ;          2. Block and attribute names are enclosed in double quotes,    
 ;             attribute width isn't.                                      
 ;          3. Widths are automatically adjusted for block scale.          
 ;          4. Names must be in uppercase.                                 
 ;          5. You can rewidth some attributes and ignore others in the    
 ;             same block.                                                 
 ;          6. Named attributes which don't exist in the block aren't a    
 ;             problem.                                                    
 ;          7. Blocks which aren't present in the drawing are ok.          
 ;          8. If this seems pretty foolproof then you don't know your     
 ;             coworkers very well.                                        
 ;                                                                         
 ;   Updated: now allows wild cards in tag names.                          
 ;   To do: allow wild cards in block names.                               
 ; 
 (DEFUN BLISTER ()
  (list '("2WIRETAG"    ("WIRE_NO" 10.5 0.85))
        '("2TERMINALS"  ("FUSE_TERMINAL_NUMBER" 12.5 1))
        '("4TERMINALS"  ("FUSE_SIZE" 3.5 1)      ("FUSE_TERMINAL_NUMBER" 12.5 1)
                        ("TERMINAL_NUMBER" 17.5 1))
 ;      '("ALT_RR_D"    ("DRAWING" 78 0.9))
        '("ATTR-D"      ("TITLE_*" 126 1)        ("REV*" 84 1.25)
                        ("DATE" 40 1.25)     ; apparently this works
                        ("DATE*" 16.5 1))    ;
        '("BILL OF MAT TEXT"
                        ("NUMBER" 8 1)           ("DESCRIPTION" 194 1)
                        ("MANUFACTURER" 36 1)    ("CATALOG_NO" 46 1)
                        ("SUPPLIER" 32 1))
        '("BOMTAG"      ("MATERIAL" 5 1))
        '("BAL1A"       ("TG1" 6.5 0.85)         ("TG2" 6.5 0.85))
        '("CABLETAG"    ("CABLE" 26 1))
        '("CABLETAG-50" ("CABLE" 46 1))
        '("CABLETAG-55" ("CABLE" 51 1))
        '("CABLE_TAG"   ("TAG" 21 1))
        '("CABLE"       ("CABLE_NO" 36 0.85)     ("APPLICATION" 95 0.85)
                        ("HP/KVA" 15 0.85)       ("VOLTS" 21 0.85)
                        ("FROM" 75 0.85)         ("VIA" 50 0.85)
                        ("TO" 75 0.85)           ("CONDUIT_SIZE_TYPE" 35 0.85)
                        ("CABLE_TYPE" 29 0.85)   ("CONDUCTOR_QUAN" 21 0.85)
                        ("CONDUCTOR_SIZE_CU" 21 0.85)
                        ("CONDUCTOR_SIZE_ALUM" 21 0.85)
                        ("CONDUCTOR_VOLTS" 21 0.85) ("CONDUCTOR_INSUL" 21 0.85)
                        ("SPARE" 21 0.85)        ("REMARKS" 240 0.85))
        '("CABLEX"      ("CABLE_NO" 36 0.85)     ("APPLICATION" 95 0.85)
                        ("HP/KVA" 15 0.85)       ("VOLTS" 21 0.85)
                        ("FROM" 75 0.85)         ("VIA" 50 0.85)
                        ("TO" 75 0.85)           ("CONDUIT_SIZE_TYPE" 35 0.85)
                        ("CABLE_TYPE" 29 0.85)   ("CONDUCTOR_QUAN" 21 0.85)
                        ("CONDUCTOR_SIZE_CU" 21 0.85)
                        ("CONDUCTOR_SIZE_ALUM" 21 0.85)
                        ("CONDUCTOR_VOLTS" 21 0.85) ("CONDUCTOR_INSUL" 21 0.85)
                        ("SPARE" 21 0.85)        ("REMARKS" 240 0.85))
        '("CBLTAG"      ("CS-RUN" 26 0.8) ("CS-APP" 45 0.8) ("CS-LOA" 7 0.8)
                        ("CS-VL1" 9 0.8)  ("CS-FRM" 63 0.8) ("CS-VIA" 18 0.8)
                        ("CS-TO" 64 0.8)  ("CS-TYP" 11 0.8) ("CS-LEN" 11 0.8)
                        ("CS-SIZ" 11 0.8) ("CS-CON" 11 0.8) ("CS-VL2" 9 0.8)
                        ("CS-RUN" 26 0.8) ("CS-APP" 45 0.8) ("CS-LOA" 7 0.8)
                        ("CS-SPA" 9 0.8)  ("CS-REM" 35 0.8))
        '("CC SCHEDULE TEXT"
                        ("CABLE_TAG" 36 1)         ("APPLICATION" 115 1)
                        ("LOAD" 19 1)              ("VOLTS" 19 1)
                        ("FROM" 116 1)             ("VIA" 44 1)
                        ("TO" 116 1)
                        ("CONDUIT_OR_CABLE_SIZE_TYPE" 19 1)
                        ("EST_LENGTH_METERS" 19 1) ("INSULVOLTS" 19 1)
                        ("CONDUCTOR_SIZE" 19 1)    ("CONDUCTOR_QUAN" 19 1)
                        ("CONDUCTOR_INSUL" 19 1)   ("CONDUCTOR_VOLTS" 19 1)
                        ("SPARE" 19 1) ("REMARKS" 134 1))
 ; This is saved because there are two versions of this kicking around.  The
 ; latest one is a bad rehash of the existing one.
;        '("CC SCHEDULE TEXT"
;                        ("CABLE_TAG" 56 1)         ("APPLICATION" 130 1)
;                        ("LOAD" 21 1)              ("VOLTS" 21 1)
;                        ("FROM" 80 1)              ("VIA" 25 1)
;                        ("TO" 80 1)
;                        ("CONDUIT_OR_CABLE_SIZE_TYPE" 21 1)
;                        ("EST_LENGTH_METERS" 21 1) ("INSULVOLTS" 21 1)
;                        ("CONDUCTOR_SIZE" 21 1)    ("CONDUCTOR_QUAN" 21 1)
;                        ("CONDUCTOR_INSUL" 21 1)   ("SPARE" 21 1)
;                        ("REMARKS" 67.5 1))
        '("CNRL TB TEXT"
                        ("*_REV_DESCRIPTION" 60 1))
        '("DETTAG"      ("DETNO" 7.5 0.85)       ("DWGNO" 7.5 0.85)
                        ("QUANTL" 9 0.85)        ("QUANTR" 9 0.85))
        '("DWGINFO"     ("DWGNO" 51 1)           ("REVNO" 6 1)
                        ("DWGTITLE" 161 0.8)     ("CADDNO" 22 1))
        '("EL-2A039 "   ("MOTOR_SIZE" 16.5 0.85) ("MOTOR_RATING" 16.5 0.85))
        '("ELEC_BASE"   ("REVDESCR" 150 1)       ("TITLE3" 170 1))  ; the BP tb
        '("FIELDTB"     ("CABLE_NO" 22 0.85)     ("CONDUCTOR_NO" 8.5 0.85))
        '("GBOMTXT"     ("DESCRIPTION" 63 0.85)
                        ("MANUFACTURER" 38 0.85)
                        ("CATALOG_NO" 38 0.85)
                        ("SIZE" 18 0.85)
                        ("SUPPLIER" 33 0.85))
        '("GCA1TB"      ("LINE1" 175 0.85)       ("LINE2" 175 0.85)
                        ("LINE3" 175 0.85) 
                        ("JOBNUM" 24 0.85)       ("DWGNUM" 70 0.85)
                        ("TBREV" 10 0.85)        ("SLOCATION" 58 0.85))
        '("HEX-TAG"     ("LINE1" 8 1)            ("LINE2" 8 1))
        '("INDEXLINE"   ("DRAWING" 80 1)         ("REV"  14 1)
                        ("TITLE" 202 1)          ("ISSUE" 42 1)
                        ("DATE" 36 1))
        '("INDEX TEXT"  ("DRAWING_NO" 45 1)      ("SHEET_NO" 37.5 1)
                        ("TITLE" 198 1)          ("REV_NO" 37.5 1))
        '("INST-TAG"    ("DEVICE" 8.5 0.9)       ("NUMBER" 8.5 0.9)
                        ("TEXT1" 7.25 0.9)       ("TEXT2" 7.25 0.9))
        '("IOFUSE"      ("FUSE_SIZE" 3.5 1)      ("FUSE_TERMINAL_NUMBER" 17.5 1))
        '("LAMICDI"     ("LAMICOID" 4.5 1))
        '("LAMICTXT"    ("QUANTITY" 10 0.85)     ("ENGRAVING" 105 0.85)
                        ("COLOUR" 56 0.85)       ("SIZE" 32 0.85))
        '("LIN-ID-R"    ("CABLE_TAG_NO" 23 0.85))
        '("LIN-ID-L"    ("CABLE_TAG_NO" 23 0.85))
        '("LISTTEXT"    ("CAD_FILENAME" 61 0.85)
                        ("DRAWNG_NO" 66 0.85)
                        ("REV_NO" 16 0.85)
                        ("TITLE" 196 0.85)
                        ("SET_ISSUED_FOR" 85 0.85))
        '("Provident TB D Size"
                        ("FAC_TAG" 45 1)         ("LOC_TAG" 45 1)
                        ("PROJ_TAG1" 45 1)       ("PROJ_TAG2" 45 1)
                        ("UNIT_TAG" 45 1)        ("TITLE#_TAG" 173 1)
                        ("AREA_TAG" 56 1)        ("CLS_TAG" 16 1)
                        ("SCL_TAG" 16 1)         ("PEL_DWG`#" 45 1)
                        ("REV`#_*" 12 1)         ("ISS_TAG_*" 48 1)
                        ("ISSDATE_*" 27 1)       ("BY_*" 12 1)
                        ("CHK_*" 12 1)           ("APP_*" 12 1)
                        ("REV_#" 15 1)           ("PDATE_#" 25 1)
                        ("DESCR_#" 84 1)         ("PROJ#_#" 26 1)
                        ("EPCM-C_#" 30 1)        ("EPCM-N_#" 26 1)
                        ("ENG_#" 11 1)           ("REF_#" 97 1)
                        ("REFDWG_#" 30 1))
       '("RWTitleblock" ("REV`#_#" 12 1)         ("ISS_TAG_#" 48 1)
                        ("ISSDATE_#" 25 1)       ("BY_#" 12 1)
                        ("CHK_#" 12 1)           ("APP_#" 12 1))
        '("SCHEDTXT"    ("QUANTITY" 13 0.85)
                        ("DESCRIPTION" 63 0.85)
                        ("MANUFACTURER" 38 0.85)
                        ("CATALOG_NO" 38 0.85)
                        ("SIZE" 18 0.85)
                        ("SUPPLIER" 33 0.85))
        '("SCHEMALIGHT" ("WATTS" 7 0.85)
                        ("TYPE" 7 0.85))
        '("STD-DETL"    ("DETAIL_NUMBER" 7 0.85) ("PAGE_NUMBER" 7 0.85))
        '("SECTION1"    ("NAME" 7 0.85)          ("DWGNO" 9 0.85))
        '("T2A-3"       ("AREA-NAME" 109 0.95)   ("CLASS" 8.5 1.1)
                        ("ENCANA-FILE-NO" 58 1.05) ("TITLE1" 182 1.15)
                        ("TITLE2" 182 1.15)      ("FACILITY" 81 0.95)
                        ("LOCATION" 81 1.05)     ("SITE-NM" 81 1)
                        ("SITE-LSD" 81 1.05)     ("SCALE" 35 0.8)
                        ("CONSULTANT" 182 1.1)   ("EPCM-NM" 35 1)
                        ("REV1" 5 0.9)           ("PDATE1" 15 0.8)
                        ("DESC1" 115 1)          ("PROJ-1" 14 0.9)
                        ("AFE-1" 16 1)           ("EPCM-C1" 17 1)
                        ("EPCM-N1" 16 1)         ("ENG-1" 8 1)
                        ("REV2" 5 0.9)           ("PDATE2" 15 0.8)
                        ("DESC2" 115 1)          ("PROJ-2" 14 0.9)
                        ("AFE-2" 16 1)           ("EPCM-C2" 17 1)
                        ("EPCM-N2" 16 1)         ("ENG-2" 8 1)
                        ("REV3" 5 0.9)           ("PDATE3" 15 0.8)
                        ("DESC3" 115 1)          ("PROJ-3" 14 0.9)
                        ("AFE-3" 16 1)           ("EPCM-C3" 17 1)
                        ("EPCM-N3" 16 1)         ("ENG-3" 8 1)
                        ("REV4" 5 0.9)           ("PDATE4" 15 0.8)
                        ("DESC4" 115 1)          ("PROJ-4" 14 0.9)
                        ("AFE-4" 16 1)           ("EPCM-C4" 17 1)
                        ("EPCM-N4" 16 1)         ("ENG-4" 8 1)
                        ("REV5" 5 0.9)           ("PDATE5" 15 0.8)
                        ("DESC5" 115 1)          ("PROJ-5" 14 0.9)
                        ("AFE-5" 16 1)           ("EPCM-C5" 17 1)
                        ("EPCM-N5" 16 1)         ("ENG-5" 8 1)
                        ("REV6" 5 0.9)           ("PDATE6" 15 0.8)
                        ("DESC6" 115 1)          ("PROJ-6" 14 0.9)
                        ("AFE-6" 16 1)           ("EPCM-C6" 17 1)
                        ("EPCM-N6" 16 1)         ("ENG-6" 8 1)
                        ("REV7" 5 0.9)           ("PDATE7" 15 0.8)
                        ("DESC7" 115 1)          ("PROJ-7" 14 0.9)
                        ("AFE-7" 16 1)           ("EPCM-C7" 17 1)
                        ("EPCM-N7" 16 1)         ("ENG-7" 8 1)
                        ("REV8" 5 0.9)           ("PDATE8" 15 0.8)
                        ("DESC8" 115 1)          ("PROJ-8" 14 0.9)
                        ("AFE-8" 16 1)           ("EPCM-C8" 17 1)
                        ("EPCM-N8" 16 1)         ("ENG-8" 8 1)
                        ("RC1" 14 1)             ("STAMP1" 32 1)
                        ("RD1" 17.5 1)           ("RDATE1" 14 0.8)
                        ("BY1" 9 0.9)            ("CHKD1" 9 0.9)
                        ("APPD1" 9 0.9)          ("RD2" 17.5 1)
                        ("RDATE2" 14 0.8)        ("BY2" 9 0.9)
                        ("CHKD2" 9 0.9)          ("APPD2" 9 0.9)
                        ("RD3" 17.5 1)           ("RDATE3" 14 0.8)
                        ("BY3" 9 0.9)            ("CHKD3" 9 0.9)
                        ("APPD3" 9 0.9)          ("RD4" 17.5 1)
                        ("RDATE4" 14 0.8)        ("BY4" 9 0.9)
                        ("CHKD4" 9 0.9)          ("APPD4" 9 0.9)
                        ("RD5" 17.5 1)           ("RDATE5" 14 0.8)
                        ("BY5" 9 0.9)            ("CHKD5" 9 0.9)
                        ("APPD5" 9 0.9)          ("RD6" 17.5 1)
                        ("RDATE6" 14 0.8)        ("BY6" 9 0.9)
                        ("CHKD6" 9 0.9)          ("APPD6" 9 0.9)
                        ("RD7" 17.5 1)           ("RDATE7" 14 0.8)
                        ("BY7" 9 0.9)            ("CHKD7" 9 0.9)
                        ("APPD7" 9 0.9)          ("RD8" 17.5 1)
                        ("RDATE8" 14 0.8)        ("BY8" 9 0.9)
                        ("CHKD8" 9 0.9)          ("APPD8" 9 0.9)
                        ("REF1" 98 1.1)          ("REFDWG1" 38 1.1)
                        ("REF2" 98 1.1)          ("REFDWG2" 38 1.1)
                        ("REF3" 98 1.1)          ("REFDWG3" 38 1.1)
                        ("STIME" 34 1)           ("FILE1" 8 1))
        '("TB"          ("FIRST_LINE" 129 0.85)
                        ("SECOND_LINE" 129 0.85)
                        ("THIRD_LINE" 129 0.85))
       '("tcmtb"        ("REV_*" 12 1)           ("ISS_TAG_#" 48 1)
                        ("ISSDATE_#" 25 1)       ("BY_#" 12 1)
                        ("CHK_#" 12 1)           ("APP_#" 12 1))
        '("TDATA"       ("DWGNAME" 44 1)         ("REV" 28 1)
                        ("TITLE" 182 1))
        '("TERMINAL BLOCK" ("TERMINAL_NUMBER" 13 1))
        '("TERMINAL BLOK" ("TERMINAL_NUMBER" 13.5 1))
        '("TITLE"       ("DWGNO" 44 0.8)         ("TITLE" 143 0.8)
                        ("IFA.DATE" 28 0.8)      ("IFB.DATE" 28 0.8)
                        ("IFC.DATE" 28 0.8)      ("AB.DATE" 28 0.8)
                        ("REV" 12 0.8)           ("REMARKS" 45 0.8))
        '("TRIDYNE_TB_D"  ("DRAWING_NUMBER" 86 1))))
 ; Ŀ
 ;   Blister end.                                                          
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of an attribute.                     
 ;   Takes one argument: the attribute entity data list.  Returns a width. 
 ; 
 (DEFUN WITS (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Vise - squeeze or stretch attributes as required.          
 ;   Arguments: Enam, a block ename.                                       
 ;              Widlst, the corresponding list of attrib. and width lists. 
 ;              Blscal, the block scale.                                   
 ; 
 (DEFUN VISE (enam widlst blscal / esav entt enam num sublst namp width realwd
                                                          scalfc widscl prev41)
  (setq esav enam)
 ; Ŀ
 ;   Repeat until come to the block end marker.                            
 ; 
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
                                                                   "SEQEND")
 ; Ŀ
 ;   Get the attribute name.                                               
 ; 
         (setq namm (cdr (assoc 2 entt)))
 ; Ŀ
 ;   Call Wcasoc to see if there is a matching sublist.                    
 ; 
         (if (setq sublst (wcasoc namm widlst ()))
             (progn
 ; Ŀ
 ;   Find the correct width from the sublist, allow for the block scale.   
 ; 
                  (setq width (* (cadr sublst) blscal))
 ; Ŀ
 ;   Find the desired width scale factor from the sublist.                 
 ; 
                  (setq txtscl (caddr sublst))
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
                  (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
                  (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ; 
                  (if (and (> realwd width)
                           (not (equal realwd width 0.1)))
 ; Ŀ
 ;   If the actual width is greater than the allowed width in the          
 ;   sublist, then adjust the width scale factor to make it fit.           
 ;   Wait: must also check to see if the width scale is greater than the   
 ;   ideal - if the attribute is too wide and the width scale is too       
 ;   large, then shrinking the attribute to fit may result in it just      
 ;   filling the space but still being too wide.                           
 ; 
                      (progn
 ; Ŀ
 ;   Compare the actual width scale to the ideal width scale.              
 ; 
                           (if (<= widscl txtscl)
 ; Ŀ
 ;   If the actual is less than or equal to the ideal, then make it fit.   
 ; 
                               (progn
                                    (setq scalfc (/ width realwd))
                                    (setq widscl (* widscl scalfc))
                                    (entmod (subst (cons 41 widscl)
                                                    prev41 entt)))
 ; Ŀ
 ;   If the actual width scale is greater than the ideal, see if the       
 ;   attribute will be too wide if if set to the ideal.                    
 ;   If so then squash to fit, if not then set to the ideal.               
 ; 
                               (progn
                                    (if (> (* realwd (/ txtscl widscl)) width)
 ; Ŀ
 ;   Squash to fit.                                                        
 ; 
                                        (progn
                                             (setq scalfc (/ width realwd))
                                             (setq widscl (* widscl scalfc))
                                             (entmod (subst (cons 41 widscl)
                                                             prev41 entt)))
 ; Ŀ
 ;   Set to the ideal width scale factor.                                  
 ; 
                                        (entmod (subst (cons 41 txtscl)
                                                        prev41 entt))))))
 ; Ŀ
 ;   Else the actual width is narrower than or equal to the available      
 ;   space.                                                                
 ; 
                      (progn
 ; Ŀ
 ;   See if the attribute is narrower than it should be - if setting the   
 ;   width scale factor to the desired value would leave the attribute     
 ;   wider than the allowable space, then increase it to fill the space.   
 ; 
                           (if (> (* realwd (/ txtscl widscl)) width)
                               (progn
                                    (setq scalfc (/ width realwd))
                                    (setq widscl (* widscl scalfc))
                                    (entmod (subst (cons 41 widscl)
                                                           prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
                               (progn
                                    (entmod (subst (cons 41 txtscl)
                                                       prev41 entt)))))))))
  (entupd esav)
 (princ))
 ; Ŀ
 ;   Vise end.                                                             
 ; 

 ; Ŀ
 ;   WcAsoc - Assoc function with wild cards.                              
 ;   Arguments: Carra, a hypothetical leading string.                      
 ;              Lisa, a list of lists, possibly containing wild cards.     
 ;   In other words this thing is backwards.                               
 ;   Would checking a b and b a work?  Maybe.........                      
 ;              Casa, case sensitive-p: t = yes, nil = no.                 
 ;   Won't crash if the leading atom in each list isn't a string, but      
 ;   may be baffled.                                                       
 ;   Returns a sublist or nil.                                             
 ; 
 (DEFUN WCASOC (carra lisa casa / sub num aso str)
  (if (null casa) (setq carra (strcase carra)))
  (setq num 0)
  (while (and (null aso) (setq sub (nth num lisa)))
         (setq num (1+ num))
         (setq str (car sub))
         (if (= (type str) 'STR)
             (progn
                  (if (null casa) (setq str (strcase str)))
                  (if (wcmatch carra str)
                      (setq aso sub)))))
 aso)
 ; Ŀ
 ;   WcAsoc end.                                                           
 ; 

 ; Ŀ
 ;   Squab - the Beethoven of Pigeons.                                     
 ; 
 (DEFUN C:SQUAB (/ blscal blist num sub ss ssnum enam entt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq blist (blister))
  (setq num 0)
  (while (setq sub (nth num blist))
         (setq num (1+ num))
         (if (setq ss (ssget "X" (list (cons 2 (car sub)))))
             (progn
                  (setq ssnum 0)
                  (while (setq enam (ssname ss ssnum))
                         (setq ssnum (1+ ssnum))
                         (setq entt (entget enam))
                         (setq blscal (abs (cdr (assoc 41 entt))))
                         (if (assoc 66 entt)
                             (vise enam (cdr sub) blscal))))))
  (command "undo" "end")
 (princ))